<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

/*
 * Penda Project
 *
 * @developer	        I-Rock Technologies Limited
 * @copyright	        Copyright (c) 2014 - 2024 Penda
 * @project link		https://penda.irock.co.zm
 * @developer link      https://www.irock.co.zm
 */

/**
 * Class Ajax
 */
class Ajax extends Admin_Controller
{
    public function __construct()
    {
        $this->load->library('session');

        $userTypeId = $this->session->userdata('user_type');
        parent::__construct($userTypeId);
    }
    public $ajax_controller = true;

    public function modal_bills_lookups()
    {
        $filter_bill = $this->input->get('filter_bill');
        $filter_vendor= $this->input->get('filter_vendor');
        $reset_table = $this->input->get('reset_table');

        $this->load->model('mdl_bills');
        $this->load->model('vendors/mdl_vendors');

        if (!empty($filter_vendor)) {
            $this->mdl_bills->by_vendor($filter_vendor);
        }

        if (!empty($filter_bill)) {
            $this->mdl_bills->by_bill($filter_bill);
        }


        $bills = $this->mdl_bills->get()->result();
        $vendors = $this->mdl_vendors->get()->result();



        $data = array(
            'bills' => $bills,
            'vendors' => $vendors,
            'filter_bill' => $filter_bill,
            'filter_vendor' => $filter_vendor
        );

        if ($filter_bill || $filter_vendor|| $reset_table) {
            $this->layout->load_view('bills/partial_bills_table_modal', $data);
        } else {
            $this->layout->load_view('bills/modal_bills_lookups', $data);
        }
    }

    public function process_bill_selections()
    {
        $this->load->model('mdl_bills');

        $bills= $this->mdl_bills->where_in('bill_id', $this->input->post('bill_ids'))->get()->result();

        foreach ($bills as $bill) {
            $bill->bill_amount = format_amount($bill->bill_amount);
        }

        echo json_encode($bills);
    }

}
